#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package SrSv::IRCd::IO;

use strict;

use Exporter 'import';
BEGIN { our @EXPORT_OK = qw(ircd_connect ircd_disconnect ircsendimm ircsend ircd_flush_queue) }

use constant {
	NL => "\015\012",
};

use SrSv::Process::InParent qw(irc_connect ircsend ircsendimm ircd_flush_queue);

use SrSv::Process::Worker qw(ima_worker);
use SrSv::Debug;
use SrSv::IRCd::State qw($ircline $ircline_real $ircd_ready);
use SrSv::IRCd::Event qw(callfuncs);
use SrSv::Unreal::Tokens;
use SrSv::Unreal::Parse qw(parse_line);

our $irc_sock;
our @queue;

BEGIN {
	my $partial;
	
	sub ircrecv {
		my $in;
		while($irc_sock->sysread(my $part, 4096)) {
			$in .= $part;
		}
		
		my @lines = split(/\015\012/, $in);
		
		$lines[0] = $partial . $lines[0];
		if($in =~ /\015\012$/s) {
			$partial = '';
		} else {
			$partial = pop @lines;
		}
		
		foreach my $line (@lines) {
			$ircline_real++ unless $line =~ /^(?:8|PING)/;
			print ">> $ircline_real $line\n" if DEBUG_ANY;
			foreach my $ev (parse_line($line)) {
				next unless $ev;

				callfuncs(@$ev);
			}
		}
	}
}

sub ircd_connect($$) {
	my ($remote, $port) = @_;
	
	print "Connecting..." if DEBUG;
	$irc_sock = IO::Socket::INET->new(
		PeerAddr => $remote,
		PeerPort => $port,
		Proto => 'tcp',
		Blocking => 0,
	) or die("Could not connect to IRC server: $!");
	print " done\n" if DEBUG;

	$irc_sock->autoflush(1);

	event::add_io_watcher(
		cb => \&ircrecv,
		fd => $irc_sock,
	);
}

sub ircd_disconnect() {
	ircd_flush_queue();
	$irc_sock->close;
}

sub ircsendimm {
	print "ircsendimm()  ima_worker: ", ima_worker(), "\n" if DEBUG;

	foreach my $line (@_) {
		# Sometimes it fails with "Resource temporarily unavailable" and I don't know why.
		while(1) {
			last if($irc_sock->syswrite($line . NL));
			
			print $! if DEBUG;
		}
		print "<< $line\n" if DEBUG_ANY;
	}
}

sub ircsend {
	print "ircsend()  ima_worker: ", ima_worker(), "\n" if DEBUG;
	if(DEBUG) {
		foreach my $x (@_) {
			print "<< $ircline $x\n";
		}
	}

	if($ircd_ready) {
		ircsendimm(@_);
	} else {
		foreach my $x (@_) {
			if($x =~ /^$tkn{NICK}[$tkn]/) {
				unshift @queue, $x;
			} else {
				push @queue, $x;
			}
		}
	}
}

sub ircd_flush_queue() {
	ircsendimm(@queue);
	undef @queue;
}

1;
