#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package SrSv::IRCd::Queue;

# The purpose of this module is to make sure lines get processed in an
# order that makes sense, e.g., a JOIN should not be processed before
# the corresponding NICKCONN has been.

# FIXME: This is O(n^2) when it could probably be O(1). It also misses some
# potential paralellism for the sake of simplicity. It also doesn't quite
# work properly, mostly with channel modes.

use strict;

use Exporter 'import';
BEGIN { our @EXPORT_OK = qw(ircd_enqueue) }

use SrSv::Debug;
use SrSv::Message qw(message);

our @queue;
our @running;

sub ircd_enqueue($) {
	my ($message) = @_;
	my ($ircline, $wf) = @$message{'IRCLINE', 'WF'};

	if($wf == 0) {
		message($message);
		return;
	}

	if(_is_runnable($message)) {
		push @running, $message;
		message($message);
	} else {
		push @queue, $message;
	}
}

sub finished {
	my ($message) = @_;

	my $ircline = $message->{IRCLINE};

	print "Called finished() for $ircline\n" if DEBUG();

	for(my $i; $i < @running; $i++) {
		if($running[$i]{IRCLINE} == $ircline) {
			splice(@running, $i, 1);
			last;
		}
	}

	if($message->{TYPE} eq 'SEOS') {
		$message->{TYPE} = 'POSTSEOS';
		message($message);
	}

	_dequeue();
}

sub _is_runnable($) {
	my ($message) = @_;
	my ($ircline, $wf) = @$message{'IRCLINE', 'WF'};
	
	foreach my $r (@running) {
		if($r->{'IRCLINE'} < $ircline and $r->{WF} < $wf) {
			return 0;
		}
	}
	
	return 1;
}

sub _dequeue {
	for(my $i; $i < @queue; $i++) {
		if(_is_runnable($queue[$i])) {
			my $message = splice(@queue, $i, 1);
			
			push @running, $message;
			message($message);
		}
	}
}

1;
