#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
package svsdb;

use strict;
use DBI;
our $dbh;

our @nrid_convert = (
	# name of table, old nickreg column, new nrid column
	['chanacc', 'nick', 'nrid'],
	['chanreg', 'founder', 'founderid'],
	['chanreg', 'successor', 'successorid'],
	['memo', 'dst', 'dstid'],
	['ms_ignore', 'nick', 'nrid'],
	['ms_ignore', 'ignorenick', 'ignoreid'],
	['nickalias', 'root', 'nrid'],
	['nickid', 'nick', 'nrid'],
	['silence', 'nick', 'nrid'],
	['svsop', 'nick', 'nrid'],
	['vhost', 'nick', 'nrid'],
	['watch', 'nick', 'nrid'],
);

sub column_exists($$) {
	my ($table, $column) = @_;
	
	my $q = $dbh->prepare("DESCRIBE $table");
	$q->execute;
	while(my ($c) = $q->fetchrow_array) {
		return 1 if $c eq $column;
	}

	return 0;
}

sub mangle_keys($$$) {
	my ($table, $old, $new) = @_;

	my (%keys, @chkeys, @dropkeys, @newkeys);

	my $q = $dbh->prepare("SHOW KEYS FROM $table");
	$q->execute;
	while(my (undef, $nu, $kname, $seq, $column) = $q->fetchrow_array) {
		$keys{$kname}[0] = $nu;
		$keys{$kname}[1][$seq-1] = $column;
	}

	foreach my $kname (keys(%keys)) {
		foreach my $col (@{$keys{$kname}[1]}) {
			if($col eq $old) {
				$col = $new;
				push @chkeys, $kname;
			}
		}
	}

	foreach my $kname (@chkeys) {
		my $cols = join(', ', @{$keys{$kname}[1]});
		
		if($kname eq 'PRIMARY') {
			push @dropkeys, "DROP PRIMARY KEY";
			push @newkeys, "ADD PRIMARY KEY ($cols)";
		}
		elsif(!$keys{$kname}[0]) {
			push @dropkeys, "DROP INDEX $kname";
			push @newkeys, "ADD UNIQUE $kname ($cols)";
		}
		else {
			push @dropkeys, "DROP INDEX $kname";
			push @newkeys, "ADD INDEX $kname ($cols)";
		}
	}

	return (join(', ', @dropkeys), join(', ', @newkeys));
}

sub nrid_convert() {
	unless(column_exists('nickreg', 'id')) {
		die("Column 'id' in nickreg does not exist! This is a bug.");
	}

	foreach my $c (@nrid_convert) {
		my ($table, $old, $new) = @$c;
		
		next if column_exists($table, $new) and not column_exists($table, $old);
		
		nrid_conv_column($table, $old, $new);
	}
}

sub nrid_conv_column($$$) {
	my ($table, $old, $new) = @_;

	my ($dropkeys, $newkeys) = mangle_keys($table, $old, $new);
	
	$dbh->do("ALTER TABLE $table ADD COLUMN $new INT(11) UNSIGNED NOT NULL AFTER $old");
	$dbh->do("UPDATE $table, nickreg SET $table.$new=nickreg.id WHERE $table.$old=nickreg.nick");
#	$dbh->do("DELETE FROM $table WHERE $table.$new=0 OR $table.$new IS NULL");
	
	my @alter;
	push @alter, $dropkeys if $dropkeys;
	push @alter, "DROP COLUMN $old";
	push @alter, $newkeys if $newkeys;
	
	$dbh->do("ALTER TABLE $table ".join(', ', @alter));
}
