#!/usr/bin/perl
#
#  Copyright saturn@surrealchat.net
#
#  Licensed under the GNU Public License 
#  http://www.gnu.org/licenses/gpl.txt
#

package triviabot;

use strict;
#no strict "refs";
#use Socket;
#use IO::Handle;
#use FreezeThaw;
use Time::Local;
use DBI;
use threads;
use threads::shared;

my $debug = 0;

#DBI->trace(3);
my $dbh;

my (
	$getrandqaid, 

	$getqa, $getcatname, $getcatid, $getcats, 

	$getuser, $getusernick, $getuserbyname, $getuserbyhost, $getuserbynick, $adduser,

	$chkuserpass, $updateuser, 

	$chkuser, $setusernick, $setnickbyhost,

	$chkscore, $incscore, $getscore, $clrstreak,

	$gettop, $getchantop,

	$addchan, $delchan, $getchanlist,
	$getchancat, $setchancat, $setchantheme,
	$getchantheme, $getchanpointlen, $setchanpointlen, 

	$chkauth, $setauth, $getauth, 
	
	$getcatacc, $getclearacc, $getstartacc, $getthemeacc,
	$setcatacc, $setclearacc, $setstartacc, $setthemeacc,

	$settheme, $gettheme
);

my (%getacc, %setacc);


my $master = 'saturn';

our (%tc, %tn, %trivia, @auth) : shared;
my @words;

sub initSQL {
	$dbh = DBI->connect("DBI:mysql:database=triviabot", "triviabot", "izgQsk12wenG2DOb",
    		{  AutoCommit => 0, RaiseError => 1, mysql_auto_reconnect => 1 });
	# Prevent timeout
	$dbh->do("SET wait_timeout=(86400*365)");
	#$dbh->trace(3);
	
	$getrandqaid = $dbh->prepare("SELECT FLOOR(RAND() * COUNT(*)) AS rand_row FROM qa WHERE cat=? GROUP BY cat");
	# Someone fagged up mysql's LIMIT, we have to re-do this every time now.
	#$getqa = $dbh->prepare("SELECT q, a FROM qa WHERE cat=? LIMIT 1, ?");

	$getcatname = $dbh->prepare("SELECT name FROM cat WHERE id=?");
	$getcatid = $dbh->prepare("SELECT id FROM cat WHERE name=?");
	$getcats = $dbh->prepare("SELECT name FROM cat");

	$getuser = $dbh->prepare("SELECT * FROM user WHERE id=?");
	$getusernick = $dbh->prepare("SELECT nick FROM user WHERE id=?");
	$getuserbyname = $dbh->prepare("SELECT id FROM user WHERE name=?");
	$getuserbyhost = $dbh->prepare("SELECT id FROM user WHERE host=?");
	$getuserbynick = $dbh->prepare("SELECT id FROM user WHERE nick=?");
	$adduser = $dbh->prepare("INSERT INTO user SET name=?, pass=?, nick=?, host=?");

	$chkuserpass = $dbh->prepare("SELECT id FROM user WHERE id=? AND pass=?");
	$updateuser = $dbh->prepare("UPDATE user SET nick=?, host=? WHERE id=?");

	$chkuser = $dbh->prepare("INSERT IGNORE INTO user SET host=?");
	$setusernick = $dbh->prepare("UPDATE user SET nick=? WHERE id=?");
	$setnickbyhost = $dbh->prepare("UPDATE user SET nick=? WHERE host=?");

	$chkscore = $dbh->prepare("INSERT IGNORE INTO score SET user=?, chan=?");
	$incscore = $dbh->prepare("UPDATE score SET score=score+?, streak=streak+1 WHERE user=? AND chan=?");
	$getscore = $dbh->prepare("SELECT score, streak FROM score WHERE user=? AND chan=?");
	$clrstreak = $dbh->prepare("UPDATE score SET streak=0 WHERE user!=? AND chan=?");

	$gettop = $dbh->prepare("SELECT * FROM score ORDER BY 1-score LIMIT 5");
	$getchantop = $dbh->prepare("SELECT * FROM score WHERE chan=? ORDER BY 1-score LIMIT 5");

	$addchan = $dbh->prepare("INSERT IGNORE INTO chan SET name=?");
	$delchan = $dbh->prepare("DELETE FROM chan WHERE name=?");
	$getchanlist = $dbh->prepare("SELECT name FROM chan");
	$getcatacc = $dbh->prepare("SELECT catacc FROM chan WHERE name=?");
	$getstartacc = $dbh->prepare("SELECT startacc FROM chan WHERE name=?");
	$getchancat = $dbh->prepare("SELECT cat FROM chan WHERE name=?");
	$setchancat = $dbh->prepare("UPDATE chan SET cat=? WHERE name=?");
	$setchantheme = $dbh->prepare("UPDATE chan SET theme=? WHERE name=?");
	$getchantheme = $dbh->prepare("SELECT theme FROM chan WHERE name=?");
	$getchanpointlen = $dbh->prepare("SELECT pointlen FROM chan WHERE name=?");
	$setchanpointlen = $dbh->prepare("UPDATE chan SET pointlen=? WHERE name=?");

	$chkauth = $dbh->prepare("INSERT IGNORE INTO uca SET user=?, chan=?");
	$setauth = $dbh->prepare("UPDATE uca SET level=? WHERE user=? AND chan=?");
	$getauth = $dbh->prepare("SELECT level FROM uca WHERE user=? AND chan=?");

	$getcatacc = $getacc{'cat'} = $dbh->prepare("SELECT catacc FROM chan WHERE name=?");
	$getclearacc = $getacc{'clear'} = $dbh->prepare("SELECT clearacc FROM chan WHERE name=?");
	$getstartacc = $getacc{'start'} = $dbh->prepare("SELECT startacc FROM chan WHERE name=?");
	$getthemeacc = $getacc{'theme'} = $dbh->prepare("SELECT themeacc FROM chan WHERE name=?");

	$setcatacc = $setacc{'cat'} = $dbh->prepare("UPDATE chan SET catacc=? WHERE name=?");
	$setclearacc = $setacc{'clear'} = $dbh->prepare("UPDATE chan SET clearacc=? WHERE name=?");
	$setstartacc = $setacc{'start'} = $dbh->prepare("UPDATE chan SET startacc=? WHERE name=?");
	$setthemeacc = $setacc{'theme'} = $dbh->prepare("UPDATE chan SET themeacc=? WHERE name=?");

	$settheme = $dbh->prepare("UPDATE chan SET prefix=?, postfix=? WHERE name=?");
	$gettheme = $dbh->prepare("SELECT prefix, postfix FROM chan WHERE name=?");

	#print $dbh->errstr;

	open WORDS, "/usr/share/dict/words";
	while(<WORDS>) {
		chomp; #lc;
		next if $_ =~ /\'/;
		push @words, $_;
	}
	close WORDS;
}



my $nick = 'TriviaBot';
my $ident = 'Trivia';
my $vhost = 'Trivia.SCnet.bot';
my $gecos = 'TriviaBot by saturn';
my $umodes = '+BHSopq';


my $nl = "\015\012";

sub begin {
	initSQL();
}

sub init {
	print "running TriviaBot init()\n";
	event::addhandler('SEOS', undef, undef, __PACKAGE__, 'triviabot::register');
#	initSQL();
	print "ran TriviaBot init()\n";
	@auth = config::readArray("tb.auth");
	#load more config stuff here
}

sub register {
	print "running TriviaBot register()\n";
	net::agent_connect($nick, $ident, $vhost, $umodes, $gecos);

	net::join($nick, $config::conf{diag});
	event::addhandler('PRIVMSG', undef, lc $nick, __PACKAGE__,'triviabot::msghandle');
	event::addhandler('NOTICE', undef, lc $nick, __PACKAGE__, 'triviabot::msghandle');
	$getchanlist->execute();
	while(my ($chan) = $getchanlist->fetchrow_array) {
		net::join($nick, $chan);
		net::setmode($nick, $chan, '+v', $nick);
		$tc{$chan} = &share( {} );
		event::addhandler('PRIVMSG', undef, lc $chan, __PACKAGE__, 'triviabot::chanmsghandle');
	}
	event::addtimer('TriviaBot__update_timer', 10, __PACKAGE__, 
			'triviabot::updatetimer');


};

sub updatetimer ($) {
	update();
	event::addtimer('TriviaBot__update_timer', 10, __PACKAGE__,
			'triviabot::updatetimer');
}
		


sub getrandqaid {
	my ($cat) = @_;

	$getrandqaid->execute($cat);
	my ($id) = $getrandqaid->fetchrow_array();
	$getrandqaid->finish;

	return $id;
}

sub getcatid {
	my ($name) = @_;

	$getcatid->execute($name);
	my ($id) = $getcatid->fetchrow_array();
	$getcatid->finish;

	return $id;
}

sub getusernick {
	my ($id) = @_;

	$getusernick->execute($id);
	my ($nick) = $getusernick->fetchrow_array();
	$getusernick->finish;

	return $nick;
}

sub setusernick {
	my ($nick, $id) = @_;

	$setusernick->execute($nick, $id);
	$setusernick->finish;
}

sub getuserbyname($) {
	my ($name) = @_;

	$getuserbyname->execute($name);
	my ($id) = $getuserbyname->fetchrow_array();
	$getuserbyname->finish;

	return $id;
}

sub getuserbyhost ($){
	my ($host) = @_;

	$getuserbyhost->execute($host);
	my ($id) = $getuserbyhost->fetchrow_array();
	$getuserbyhost->finish;

	return $id;
}

sub getuserbynick {
	my ($nick) = @_;

	$getuserbynick->execute($nick);
	my ($id) = $getuserbynick->fetchrow_array();
	$getuserbynick->finish;

	return $id;
}

sub getcatname ($) {
	my ($id) = @_;

	$getcatname->execute($id);
	my ($name) = $getcatname->fetchrow_array();
	$getcatname->finish;

	return $name;
}

sub incscore {
	my ($user, $chan, $len) = @_;

	$getchanpointlen->execute($chan);
	my ($pl) = $getchanpointlen->fetchrow_array;
	$getchanpointlen->finish;
	
	$len=1 unless $pl;
	
	$chkscore->execute($user, $chan);
	$chkscore->finish;

	$incscore->execute($len, $user, $chan);
	$incscore->finish;

	$clrstreak->execute($user, $chan);
	$clrstreak->finish;
}

sub getscore {
	my ($user, $chan) = @_;

	$getscore->execute($user, $chan);
	my ($score, $streak) = $getscore->fetchrow_array();
	$getscore->finish;

	return $score, $streak;
}

sub getchancat {
	my ($chan) = @_;

	$getchancat->execute($chan);
	my ($cat) = $getchancat->fetchrow_array;
	$getchancat->finish;

	return $cat;
}

sub setchancat {
	my ($cat, $chan) = @_;

	$setchancat->execute($cat, $chan);
	$setchancat->finish;
}

sub getchanpointlen {
	my $chan = shift;

	$getchanpointlen->execute($chan);
	my ($a) = $getchanpointlen->fetchrow_array;
	$getchanpointlen->finish;

	return $a;
}

sub setauth {
	my ($level, $user, $chan) = @_;

	$chkauth->execute($user, $chan);
	$chkauth->finish;

	$setauth->execute($level, $user, $chan);
	$setauth->finish;
}

sub getauth {
	my ($user, $chan) = @_;

	$getauth->execute($user, $chan);
	my ($level) = $getauth->fetchrow_array;
	$getauth->finish;
	
	return $level;
}

sub getnauth ($$) {
	my ($nick, $chan) = @_;

	return getauth(getuserbynick($nick), $chan);
}

sub scramble ($) {
	my ($in) = @_;

	my @in = split(//, $in);
	my @out;

	while(@in) {
		my $x = rand(@in);
		push @out, $in[$x];
		splice @in, $x, 1;
	}

	return join(' ', @out);
}

sub notice ($@){
	my ($target, @msg) = @_;
	net::notice($nick, $target, @msg);
}

sub msg ($@) {
	my ($target, @msg) = @_;
	my ($pre, $post);

	if($target =~ /^#/) {
		$gettheme->execute($target);
		($pre, $post) = $gettheme->fetchrow_array;
		$gettheme->finish;
	}
	my @reply;
#	while(my $x=shift) {net::privmsg($nick, $rnick, $pre . $x . $post);}
	foreach my $x (@msg) {push @reply, $pre . $x . $post;}
	net::privmsg($nick, $target, @reply);
}

sub auth ($) {
	my ($in) = @_;
	$in =~ /^:(.+?)\s/;
	my $ident = $1;
	my @ident = split(/\!|\@/, $ident);

	return 1 if adminserv::is_ircop($in);

	foreach my $x (@auth) {
		my @x = split(/\!|\@/, $x);
		my $ok = 1;

		for(my $i=0; $i<@x; $i++) {
			if($x[$i] eq "*") {
				next;
			}

			elsif($x[$i] =~ /^\*(.*)/) {
				$ok=0 unless $ident[$i] =~ /$1$/;
			}

			elsif($x[$i] =~ /(.*)\*$/) {
				$ok=0 unless $ident[$i] =~ /^$1/;
			}

			else {
				$ok=0 unless $ident[$i] eq $x[$i];
			}
		}

		return 1 if $ok == 1;
	}

	return 0;
}
	

sub update() {
	my @chans = keys(%tc);
	foreach my $chan (@chans) {
		if(defined($tc{$chan}{STATE}) and $tc{$chan}{STATE} == 1) {
			unless(defined($tc{$chan}{CAT})) {
				if(defined(my $cat = getchancat($chan))) {
					$tc{$chan}{CAT} = $cat;
				} else {
					$tc{$chan}{CAT} = getcatid("general");
					setchancat($tc{$chan}{CAT}, $chan);
				}
			}
			
			$tc{$chan}{MAXHINTS} = 3;

			$tc{$chan}{HINTS} = 0;

			unless($tc{$chan}{CAT} == 39) {
				my $old = $tc{$chan}{QNO};
				$tc{$chan}{QNO} = getrandqaid($tc{$chan}{CAT}) while($tc{$chan}{QNO} == $old);
				my $new = $tc{$chan}{QNO};
				my $getqa = $dbh->prepare("SELECT q, a FROM qa WHERE cat=? LIMIT $new, 1");
				$getqa->execute($tc{$chan}{CAT});
				($tc{$chan}{Q}, $tc{$chan}{A}) = $getqa->fetchrow_array();
			} else {
				$tc{$chan}{A} = $words[rand(@words)];
				$tc{$chan}{Q} = "Unscramble this word: " . scramble($tc{$chan}{A});
			}
			
			
			if(getchanpointlen($chan)) {
				msg($chan, "For " . length($tc{$chan}{A}) . " points, " . $tc{$chan}{Q});
			} else {
				msg($chan, $tc{$chan}{Q});
			}

			my $clue = $tc{$chan}{A};
			$clue =~ s/\w/*/g;
			msg($chan, $clue);
			
			$clue =~ s/\*/0/g;
			$tc{$chan}{CLUEMASK} = $clue;

			my $mwc = $tc{$chan}{A};
			$mwc =~ s/\W//g;
			$tc{$chan}{MWC} = length($mwc);
			
			$tc{$chan}{STATE}++;
			next;
		}

		if(defined($tc{$chan}{STATE}) and $tc{$chan}{STATE} == 2) {
			#msg($chan, "Ten seconds have elapsed.");
			$tc{$chan}{HINTS}++;
			if($tc{$chan}{HINTS} == 0) {
				$tc{$chan}{STATE}++;
				next;
			}

			my $ans = $tc{$chan}{A};
			my $cluemask = $tc{$chan}{CLUEMASK};
			my $clue;
			my $unmc = int($tc{$chan}{MWC}/($tc{$chan}{MAXHINTS}+1));

			if($unmc == 0 and $tc{$chan}{MWC} > $tc{$chan}{HINTS}) {
				$unmc = 1;
			}

			while($unmc > 0) {
				my $newcm;
				
				for(my $i; $i < length($ans); $i++) {
					my $m = substr($cluemask, $i, 1);

					if($m eq '0' and rand() < 1/($tc{$chan}{MAXHINTS}+1) and $unmc > 0) {
						$m = '1';
						$unmc--;
					}

					$newcm .= $m;
				}
				$cluemask = $newcm;
			}
			
			for(my $i; $i < length($ans); $i++) {
				my $x = substr($ans, $i, 1);
				my $m = substr($cluemask, $i, 1);
				
				$x =~ s/\w/*/ if($m eq '0');
				
				$clue .= $x;
			}
			
			msg($chan, $clue);
			
			$tc{$chan}{CLUEMASK} = $cluemask;
			$tc{$chan}{STATE}++ if $tc{$chan}{HINTS} == $tc{$chan}{MAXHINTS};
			next;
		}

		if(defined($tc{$chan}{STATE}) and $tc{$chan}{STATE} == 3) {
			$tc{$chan}{STATE}++;
			next;
		}

		if(defined($tc{$chan}{STATE}) and $tc{$chan}{STATE} == 4) {
			$tc{$chan}{STATE} = 1;
			$tc{$chan}{IDLE}++;

			if($tc{$chan}{IDLE} > 5) {
				msg($chan, "The answer was: " . $tc{$chan}{A} . ". Stopping trivia.");
				delete $tc{$chan};
			} else {
				msg($chan, "The answer was: " . $tc{$chan}{A} . ". Going to next question.");
			}
			
			next;
		}
		
	}
}

sub chanmsghandle($$$) {
	my ($rnick, $target, $msg) = @_;
	notice($config::conf{diag}, "Hi Folks. this is triviabot here. You rang?") if $debug;
	if($target =~ m/^#/) {
		notice($config::conf{diag}, 'Hi Folks. this is triviabot\'s '.
		     'channel message handler') if $debug;
		notice($config::conf{diag}, 'this is what I see:'.
			$rnick.' '.$target.' '.$msg) if $debug;
			
		my $chan = lc $target;

		if($msg =~ /^!help/i) {
			msg($chan, "Commands: !trivon, !trivoff, !category, !skip, !top, !scores, !theme HERE, !pointlen, !auth <user> <level>, !level, !acc",
				qq{To log in, type "/msg TriviaBot id <username> <password>"});
		}

		elsif($msg =~ /^!trivon/i) {
			$getstartacc->execute($chan);
			my ($acc) = $getstartacc->fetchrow_array;
			$getstartacc->finish;

			unless(getnauth($rnick, $chan) >= $acc) { #or auth($in)
				msg($chan, "Permission denied.");
				next;
			}	
				
			unless(defined($tc{$chan})) {
				$tc{$chan} = &share( {} );
			}
			unless($tc{$chan}{STATE}) {
				$tc{$chan}{STATE} = 1;
				msg($chan, "Starting Trivia.");
			}
		}

		elsif($msg =~ /^!trivoff/i) {
			$getstartacc->execute($chan);
			my ($acc) = $getstartacc->fetchrow_array;
			$getstartacc->finish;
										
			unless(getnauth($rnick, $chan) >= $acc) { #or auth($in)
					msg($chan, "Permission denied.");
					next;
			}

			if($tc{$chan}{STATE}) {
				$tc{$chan}{STATE} = 0;
				msg($chan, "Stopping Trivia.");
			}
		}
			
		elsif($msg =~ /^!category$/i) {
			my @cats;
			
			$getcats->execute();
			while(my ($name) = $getcats->fetchrow_array()) {
				push @cats, $name;
			}
				
			msg($chan, "Available Categories:", join(", ", @cats));
			msg($chan, "Current Category: ".getcatname(getchancat($chan)));
		}

		elsif($msg =~ /^!category (.*)/i) {
			my $cat = $1;
			my $id;

			$getcatacc->execute($chan);
			my ($acc) = $getcatacc->fetchrow_array;
			$getcatacc->finish;
										
			unless(getnauth($rnick, $chan) >= $acc) { # or auth($in)
				msg($chan, "Permission denied.");
				next;
			}

			if($id = getcatid($cat)) {
				delete($tc{$chan});
				$tc{$chan} = &share( {} );
				$tc{$chan}{CAT} = $id;
				setchancat($id, $chan);
				msg($chan, "The category is now $cat.");
			} else {
				msg($chan, "I don't know anything about $cat!");
			}
		}

		elsif($msg =~ /^!skip$/i) {
			$getstartacc->execute($chan);
			my ($acc) = $getstartacc->fetchrow_array;
			$getstartacc->finish;

			unless(getnauth($rnick, $chan) >= $acc) { # or auth($in)
				msg($chan, "Access denied.");
				next;
			}

			msg($chan, "The answer was: " . $tc{$chan}{A} . ". Going to next question.");
			$tc{$chan}{IDLE} = 0;
			$tc{$chan}{STATE} = 1;
		}

		elsif($msg =~ /^!top$/i) {
			msg($chan, "All-Time High Scores:");
			$gettop->execute();
			while(my ($uid, $schan, $score) = $gettop->fetchrow_array) {
				my $user=getusernick($uid);

				msg($chan, join(" ", $score, $user, $schan));
			}
			$gettop->finish;
		}

		elsif($msg =~ /^!scores$/i) {
			msg($chan, "High Scores:");
			$getchantop->execute($chan);
			while(my ($uid, $schan, $score) = $getchantop->fetchrow_array) {
				my $user=getusernick($uid);
				msg($chan, join(" ", $score, $user));
			}
			$getchantop->finish;
		}

		elsif($msg =~ /^!score$/i) {
			if(my $user = getuserbyhost($nick)) {
				msg($chan, "$rnick score: ".getscore($user, $chan));
			} else {
				msg($chan, "I don't know who $rnick is!");
			}
		}

		elsif($msg =~ /^!score (\S+)$/i) {
			my $user;
			if($user = getuserbyname($1) or $user = getuserbynick($1)) {
				msg($chan, "$1 score: ".getscore($user, $chan));
			} else {
				msg($chan, "I don't know who $1 is!");
			}
		}

		elsif($msg =~ /^!theme (.*)HERE(.*)/i) {
			my ($pre, $post) = ($1, $2);

			$getthemeacc->execute($chan);
			my ($acc) = $getthemeacc->fetchrow_array;
			$getthemeacc->finish;
										
			unless(getnauth($rnick, $chan) >= $acc) { #or auth($in)
				msg($chan, "Permission denied.");
				next;
			}

			$settheme->execute($pre, $post, $chan);
			$settheme->finish;
			msg($chan, "Theme updated.");
		}

		elsif($msg =~ /^!pointlen$/i) {
			$getclearacc->execute($chan);
			my ($acc) = $getclearacc->fetchrow_array;
			$getclearacc->finish;

			unless(getnauth($rnick, $chan) > $acc) { #or auth($in)
				msg($chan, "Permission denied.");
				next;
			}

			$getchanpointlen->execute($chan);
			my ($pl) = $getchanpointlen->fetchrow_array;
			$getchanpointlen->finish;

			$setchanpointlen->execute(($pl ? 0 : 1), $chan);
			$setchanpointlen->finish;

			msg($chan, "Answer length bonuses are now " . ($pl ? 'off.' : 'on.'));
		}	

		#if(0) { #XXX FIXME: clear scores here
		#	$getcatacc->execute($chan);
		#	my ($acc) = $getcatacc->fetchrow_array;
		#	$getcatacc->finish;

		#	unless(getnauth($rnick, $chan) > $acc) { #or auth($in)
		#		msg($chan, "Permission denied.");
		#		next;
		#	}

			#stuff goes here
		#}

		elsif($msg =~ /^!acc ?(\S*)/i) {
			my ($qnick) = ($1);
			my ($uid, $acc);

			$qnick=$rnick if($qnick eq '');

			if($uid = getuserbynick($qnick)) {
				if($acc = getauth($uid, $chan)) {
					msg($chan, "$qnick has level $acc access in $chan");
				} else {
					msg($chan, "$qnick is logged in.");
				}
			} else {
					msg($chan, "$qnick is not logged in.");
			}
		}		

		elsif($msg =~ /^!auth (\S+) (\d+)$/i) {
			my ($anick, $level) = ($1, $2);

			if($level < getauth(getuserbynick($rnick), $chan)) { #or auth($in)
				my $auid = getuserbynick($anick);
				
				if($auid) {
					setauth($level, $auid, $chan);
					msg($chan, "$anick is now authorized in $chan at level $level.");
				} else {
					msg($chan, "User unknown: $anick. Be sure $anick is logged in.");
				}
			} else {
				msg($chan, "Permission denied.");
			}
		}
			
		elsif($msg =~ /^!level$/i) {
			my @keys = keys(%getacc);
			my @values = values(%getacc);

			for(my $i; $i<@keys; $i++) {
				$values[$i]->execute($chan);
				my $a = $values[$i]->fetchrow_array;
				$values[$i]->finish;

				msg($chan, $keys[$i] . ' ' . $a);
			}
		}
			
		elsif($msg =~ /^!level (\w+) (\d+)/i) {
			my ($perm, $level) = (lc($1), $2);
			next unless defined($setacc{$perm});

			$getacc{$perm}->execute($chan);
			my $acc = $getacc{$perm}->fetchrow_array;
			$getacc{$perm}->finish;

			my $auth = getnauth($rnick, $chan);

			if(($level <= $auth and $acc <= $auth)) { #or auth($in)
				$setacc{$perm}->execute($level, $chan);
				$setacc{$perm}->finish;
				msg($chan, "$perm now requires level $level access.");
			} else {
				msg($chan, "Permission denied.");
			}
		}
				
	}

	if($target =~ /(#\S*?)/i) {
		#my ($rnick, $rmask, $chan, $msg) = ($1, $2, $3, $4);
		my $chan = lc $target;
		my ($ident, $vhost) = nickserv::get_vhost($nick);
		my $rmask = "$ident\@$vhost";

		if($tc{$chan}{STATE} > 1 and $msg =~ /^$tc{$chan}{A}$/i) {
			my $ans = $tc{$chan}{A};
			if(my $user = getuserbyhost($rmask)) {
				setusernick($rnick, $user);

				incscore($user, $chan, length($tc{$chan}{A}));

				msg($chan, "$rnick is correct - $ans. Score: ".join(' Streak: ', getscore($user, $chan)));
			} else {
				msg($chan, "$rnick is correct - $ans. $rnick is not logged in!");
		}
		$tc{$chan}{IDLE} = 0;
		$tc{$chan}{STATE} = 1;
		}
	}
}

sub msghandle($$$) {
    my ($rnick, $target, $msg) = @_;
    notice($config::conf{diag}, "Hi Folks. this is triviabot here. You rang?") if $debug;
    notice($config::conf{diag}, "$rnick $target $msg") if $debug;
    
		my ($ident, $vhost) = nickserv::get_vhost($nick);
		my $rmask = "$ident\@$vhost";


		if($msg =~ /^id (\S+) (\S+)$/i) {
			my ($user, $pass) = ($1, $2);
			my $id = getuserbyname($user);

			if($id) {
				$chkuserpass->execute($id, $pass);
				if($chkuserpass->fetchrow_array) {
					$updateuser->execute($rnick, $rmask, $id);
					$updateuser->finish;
					notice($rnick, "You are now recognized.");
				} else {
					notice($rnick, "Incorrect password.");
				}
				$chkuserpass->finish;
			} else {
				$adduser->execute($user, $pass, $rnick, $rmask);
				$adduser->finish;

				notice($rnick, "New user created.", "User: $user", "Pass: $pass");
			}
				
			$dbh->commit;
			next;
		}

		if($msg =~ /^help/i) {
			print "rnick: ".$rnick;
			notice($rnick,
				"- This is TriviaBot.",
				"-",
				"- Available Commands:",
				"-  ID <name> <password>: Enable score tracking."
			);
		}

		unless(auth($rnick)) {
			next;
		}

		if($msg =~ /^help/i) {
			net::notice($nick, $rnick,
				"-",
				"-  JOIN #channel: Join a channel.",
				"-  PART #channel: Leave a channel.",
				"-  NOTICE nick message: Say something.",
				"-  MSG nick message: Say it again.",
				"-  RAW message: Say it from the heart.",
				"-",
				"-  AUTH hostmask: Allow someone to control me.");
		}

		if($msg =~ /^join (\S*)/i) {
			my $chan = lc($1);

			$addchan->execute($chan);
			$addchan->finish();
			net::join($nick, $chan);
			net::setmode($nick, $chan, '+v', $nick);
		}

		if($msg =~ /^part (\S*)/i) {
			my $chan = lc($1);

			$delchan->execute($chan);
			$delchan->finish();
			net::part($nick, $chan, '');
		}

		if($msg =~ /^notice (\S*) (.*)/i) {
			net::notice($1, $2);
		}

		if($msg =~ /^msg (\S*) (.*)/i) {
			net::privmsg($nick, $1, $2);
		}

		if($msg =~ /^auth (\S+)/) {
			my $tmp = $1;
			if($tmp =~ /^-(.*)/) {
				$tmp = $1;
				for(my $i=0; $i<@auth; $i++) {
					if ($auth[$i] =~ /$tmp/i) {
						delete $auth[$i];
					}
				}
			}

			else { push @auth, $1; }
		}
		elsif($msg =~ /^auth/) {
			notice($rnick, "Authorized Clients", @auth);
		}

		#if($in =~ /:$myhost .*(PRIVMSG|NOTICE) $nick\s*:(.*)/i) {
		#	my $msg = $2;
		#}
	#}
}

1;
