#!/usr/bin/perl

#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
no strict 'refs';

use constant { # Need them up here, before anybody derefs them.
	ST_PRECONNECT => 0,
	ST_LOADMOD => 1,
	ST_NORMAL => 2,
	ST_SHUTDOWN => 3,
	ST_CLOSED => 4,
	NETDUMP => 0,
};

use Cwd 'abs_path';
use File::Basename;

our $prefix = dirname(abs_path($0));

use Getopt::Long;
BEGIN {
	my @debug_pkgs;

	GetOptions(
		"debug:s" => \@debug_pkgs,
	);

	if(@debug_pkgs) {
		require SrSv::Debug;

		SrSv::Debug::enable();
		push @debug_pkgs, 'main';
		foreach my $pkg (@debug_pkgs) {
			$SrSv::Debug::debug_pkgs{$pkg} = 1;
		}
	}
}

use SrSv::OnIRC (1);

use SrSv::Debug;
use SrSv::Conf 'main';

use IO::Socket;
use Carp;

use libs::config;
#use libs::thread;
use libs::misc;
use libs::event;
use libs::net;
use libs::help;
use libs::modes;
use libs::log;
use libs::email;
use libs::fmt;
use libs::module;

use SrSv::Process::Init ();
use SrSv::Process::Worker qw(spawn);
use SrSv::Message qw(add_callback);
use SrSv::Timer qw(begin_timer);

use SrSv::Conf 'main';
*conf = \%main_conf; #FIXME

STDOUT->autoflush(1);

our $progname = 'SurrealServices';
our $version = '0.4.0-rc3';
our $extraversion = 'configured for UnrealIRCd 3.2.5 and up';

#FIXME: Figure out where $rsnick belongs and update all references
our $rsnick; *rsnick = \$core::rsnick;

#module::load();

print "Starting $progname $version.\n";

unless(DEBUG) {
	exit if fork;
	close STDIN;
	close STDOUT;
}

#my $fd = worker::spawn();
#store_fd(['main::print', "Hello, world!\n"], $fd);

#add_callback({
#	TRIGGER_COND => {CLASS => 'IRCD'},
#	CALL => 'main::print'
#});

#dispatch::message({
#	TYPE => 'TEST',
#	MESSAGE => 'hi'
#});


#sub print { print "got a ".$_[0]{TYPE}." message with args ".join(' ', @{$_[0]{ARGS}})."\n" };

config::loadconfig();

module::load();
net::serv_connect();

for(1..$main_conf{procs}) { spawn(); }

SrSv::Process::Init::do_init();
module::begin();

begin_timer();

event::loop();
