# CREATE DATABASE services;
# USE services;

#
# Table structure for table 'akick'
#

# DROP TABLE IF EXISTS akick;
CREATE TABLE `akick` (
  `chan` varchar(32) NOT NULL default '',
  `nick` varchar(30) NOT NULL default '',
  `ident` varchar(10) NOT NULL default '',
  `host` varchar(64) NOT NULL default '',
  `adder` varchar(30) NOT NULL default '',
  `reason` text,
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`,`nick`,`ident`,`host`),
  KEY `chan` (`chan`)
) TYPE=MyISAM;

#
# Table structure for table 'bot'
#

# DROP TABLE IF EXISTS bot;
CREATE TABLE `bot` (
  `nick` char(30) NOT NULL default '',
  `ident` char(10) NOT NULL default '',
  `vhost` char(64) NOT NULL default '',
  `gecos` char(50) NOT NULL default '',
  `flags` mediumint NOT NULL default '1',
  PRIMARY KEY  (`nick`)
) TYPE=MyISAM;

#
# Table structure for table 'chan'
#

# DROP TABLE IF EXISTS chan;
CREATE TABLE `chan` (
  `chan` char(32) NOT NULL default '',
  `modes` char(63) binary NOT NULL default '',
  `seq` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`)
) TYPE=HEAP;

#
# Table structure for table 'chanacc'
#

# DROP TABLE IF EXISTS chanacc;
CREATE TABLE `chanacc` (
  `chan` char(32) NOT NULL default '',
  `nrid` int(11) unsigned NOT NULL default '0',
  `level` tinyint(3) NOT NULL default '0',
  `adder` char(30) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `last` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`,`nrid`)
) TYPE=MyISAM;

#
# Table structure for table 'chanban'
#

CREATE TABLE `chanban` (
  `chan` varchar(32) NOT NULL default '',
  `mask` varchar(110) NOT NULL default '',
  `setter` varchar(30) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `type` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`,`mask`,`type`)
) TYPE=HEAP;

#
# Table structure for table 'chanclose'
#

CREATE TABLE `chanclose` (
  `chan` char(30) NOT NULL default '',
  `nick` char(30) NOT NULL default '',
  `reason` text NOT NULL default '',
  `time` int(11) unsigned NOT NULL default '0',
  `type` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY (`chan`)
) TYPE=MyISAM;

#
# Table structure for table 'chanlvl'
#

# DROP TABLE IF EXISTS chanlvl;
CREATE TABLE `chanlvl` (
  `chan` char(32) NOT NULL default '',
  `perm` smallint(5) unsigned NOT NULL default '0',
  `level` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`chan`,`perm`)
) TYPE=MyISAM;

#
# Table structure for table 'chanperm'
#

# DROP TABLE IF EXISTS chanperm;
CREATE TABLE `chanperm` (
  `name` char(10) NOT NULL default '',
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `level` tinyint(4) NOT NULL default '0',
  `max` tinyint(3) unsigned NOT NULL default 0,
  PRIMARY KEY  (`name`),
  UNIQUE KEY `id` (`id`)
) TYPE=MyISAM;

#
# Table structure for table 'chanreg'
#

# DROP TABLE IF EXISTS chanreg;
CREATE TABLE `chanreg` (
  `chan` varchar(32) NOT NULL default '',
  `descrip` varchar(255) default NULL,
  `regd` int(11) unsigned NOT NULL default '0',
  `last` int(11) unsigned NOT NULL default '0',
  `topicer` varchar(30) NOT NULL default '',
  `topicd` int(11) unsigned NOT NULL default '0',
  `modelock` varchar(63) binary NOT NULL default '+ntr',
  `founderid` int(11) unsigned NOT NULL default '0',
  `successorid` int(11) unsigned NOT NULL default '0',
  `bot` varchar(30) NOT NULL default '',
  `flags` mediumint(8) unsigned NOT NULL default '0',
  `bantype` tinyint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`)
) TYPE=MyISAM;

#
# Table structure for table 'chanuser'
#

# DROP TABLE IF EXISTS chanuser;
CREATE TABLE `chanuser` (
  `seq` mediumint(8) unsigned NOT NULL default '0',
  `nickid` int(11) unsigned NOT NULL default '0',
  `chan` char(32) NOT NULL default '',
  `joined` tinyint(3) unsigned NOT NULL default '0',
  `op` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`nickid`,`chan`),
  KEY `chan` (`chan`),
  KEY `nickid` (`nickid`)
) TYPE=HEAP;

#
# Table structure for table 'ircop'
#

# DROP TABLE IF EXISTS ircop;
CREATE TABLE `ircop` (
  `nick` char(30) NOT NULL default '',
  `level` tinyint(3) unsigned NOT NULL default '0',
  `pass` char(127) binary NOT NULL default '',
  PRIMARY KEY  (`nick`)
) TYPE=MyISAM;

#
# Table structure for table 'logonnews'
#

# DROP TABLE IF EXISTS logonnews;
CREATE TABLE `logonnews` (
  `setter` char(30) NOT NULL default '',
  `type` char(1) NOT NULL default 'u',
  `id` tinyint(3) unsigned NOT NULL default 0,
  `time` int(11) unsigned NOT NULL default '0',
  `expire` int(11) unsigned NOT NULL default '0',
  `msg` text NOT NULL
) TYPE=MyISAM;

#
# Table structure for table 'memo'
#

# DROP TABLE IF EXISTS memo;
CREATE TABLE `memo` (
  `src` varchar(30) NOT NULL default '',
  `dstid` int(11) unsigned NOT NULL default '0',
  `chan` varchar(32) NOT NULL default '',
  `time` int(11) unsigned NOT NULL default '0',
  `flag` tinyint(3) unsigned NOT NULL default '0',
  `msg` text NOT NULL,
  PRIMARY KEY  (`src`,`dstid`,`chan`,`time`),
  KEY `dst` (`dstid`)
) TYPE=MyISAM;

#
# Table structure for table 'ms_ignore'
#

CREATE TABLE `ms_ignore` (
  `nrid` int(11) unsigned NOT NULL default '0',
  `ignoreid` int(11) unsigned NOT NULL default '0',
  `time` int(11) unsigned NOT NULL default '0',
  `id` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`nrid`,`ignoreid`),
  UNIQUE KEY `nickid` (`nrid`,`id`)
) TYPE=MyISAM;

#
# Table structure for table 'nickalias'
#

# DROP TABLE IF EXISTS nickalias;
CREATE TABLE `nickalias` (
  `nrid` int(11) unsigned NOT NULL default '0',
  `alias` char(30) NOT NULL default '',
  `protect` tinyint(4) NOT NULL default '1',
  `last` int(11) unsigned NOT NULL default 0,
  PRIMARY KEY  (`nrid`,`alias`),
  UNIQUE KEY `alias` (`alias`),
  KEY `root` (`nrid`)
) TYPE=MyISAM;

#
# Table structure for table 'nickchg'
#

# DROP TABLE IF EXISTS nickchg;
CREATE TABLE `nickchg` (
  `seq` mediumint(8) unsigned NOT NULL default '0',
  `nickid` int(11) unsigned NOT NULL default '0',
  `nick` char(30) NOT NULL default '',
  PRIMARY KEY  (`nick`)
) TYPE=HEAP;

#
# Table structure for table 'nickid'
#

# DROP TABLE IF EXISTS nickid;
CREATE TABLE `nickid` (
  `id` int(10) unsigned NOT NULL default '0',
  `nrid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`,`nrid`),
  KEY `id` (`id`)
) TYPE=HEAP;

#
# Table structure for table 'nickreg'
#

# DROP TABLE IF EXISTS nickreg;
CREATE TABLE `nickreg` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nick` char(30) NOT NULL default '',
  `pass` char(127) binary NOT NULL default '',
  `email` char(127) NOT NULL default '',
  `regd` int(11) unsigned NOT NULL default '0',
  `last` int(11) unsigned NOT NULL default '0',
  `flags` mediumint(3) unsigned NOT NULL default '1',
  `ident` char(10) NOT NULL default '',
  `vhost` char(64) NOT NULL default '',
  `gecos` char(50) NOT NULL default '',
  `quit` char(127) NOT NULL default '',
  `nearexp` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nick` (`nick`)
) TYPE=MyISAM;

CREATE TABLE `sesexname` (
  `host` varchar(64) NOT NULL default '',
  `serv` tinyint(1) NOT NULL default 0,
  `adder` varchar(3) NOT NULL default '',
  `lim` mediumint(8) unsigned NOT NULL default 0,
  `reason` varchar(255) NOT NULL default '',
  PRIMARY KEY (`host`)
);

CREATE TABLE `sesexip` (
  `ip` int(10) unsigned NOT NULL default '',
  `mask` tinyint(3) NOT NULL default 0,
  `adder` varchar(3) NOT NULL default '',
  `lim` mediumint(8) unsigned NOT NULL default 0,
  `reason` varchar(255) NOT NULL default '',
  PRIMARY KEY (`ip`)
);

#
# Table structure for table 'olduser'
#

# DROP TABLE IF EXISTS olduser;
CREATE TABLE `olduser` (
  `id` int(11) unsigned NOT NULL default '0',
  `nick` char(30) NOT NULL default '',
  `time` int(11) unsigned NOT NULL default '0',
  `inval` tinyint(4) NOT NULL default '0',
  `ident` char(10) NOT NULL default '',
  `host` char(64) NOT NULL default '',
  `vhost` char(64) NOT NULL default '',
  `server` char(64) NOT NULL default '',
  `modes` char(30) NOT NULL default '',
  `gecos` char(50) NOT NULL default '',
  `guest` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nick` (`nick`)
) TYPE=HEAP;

#
# Table structure for table 'qline'
#

# DROP TABLE IF EXISTS qline;
CREATE TABLE `qline` (
  `mask` varchar(30) NOT NULL default '',
  `setter` varchar(30) NOT NULL default '',
  `time` int(11) unsigned NOT NULL default '0',
  `expire` int(11) unsigned NOT NULL default '0',
  `reason` text NOT NULL,
  PRIMARY KEY  (`mask`),
  KEY `time` (`time`),
  KEY `expire` (`expire`)
) TYPE=MyISAM;

#
# Table structure for table 'silence'
#

# DROP TABLE IF EXISTS silence;
CREATE TABLE `silence` (
  `nrid` int(11) unsigned NOT NULL default '0',
  `mask` char(106) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `expiry` int(10) unsigned NOT NULL default '0',
  `comment` char(100) default NULL,
  PRIMARY KEY  (`nrid`,`mask`),
  KEY `nick` (`nrid`)
) TYPE=MyISAM;

#
# Table structure for table 'svsop'
#

# DROP TABLE IF EXISTS svsop;
CREATE TABLE `svsop` (
  `nrid` int(11) unsigned NOT NULL default '0',
  `level` tinyint(3) unsigned NOT NULL default '0',
  `adder` char(30) NOT NULL default '',
  PRIMARY KEY  (`nrid`)
) TYPE=MyISAM;

#
# Table structure for table 'user'
#

# DROP TABLE IF EXISTS user;
CREATE TABLE `user` (
  `id` int(11) unsigned NOT NULL default '0',
  `nick` char(30) NOT NULL default '',
  `time` int(11) unsigned NOT NULL default '0',
  `inval` tinyint(4) NOT NULL default '0',
  `ident` char(10) NOT NULL default '',
  `host` char(64) NOT NULL default '',
  `vhost` char(64) NOT NULL default '',
  `cloakhost` char(64) default NULL,
  `ip` int(8) unsigned NOT NULL default '0',
  `server` char(64) NOT NULL default '',
  `modes` char(30) NOT NULL default '',
  `gecos` char(50) NOT NULL default '',
  `guest` tinyint(1) NOT NULL default '0',
  `online` tinyint(1) unsigned NOT NULL default '0',
  `quittime` int(11) unsigned NOT NULL default '0',
  `flood` tinyint(1) unsigned NOT NULL default '0',
  `flags` mediumint(10) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nick` (`nick`),
  KEY `ip` (`ip`)
) TYPE=HEAP;

#
# Table structure for table 'vhost'
#

CREATE TABLE `vhost` (
  `nrid` int(11) unsigned NOT NULL default '0',
  `ident` char(10) NOT NULL default '',
  `vhost` char(64) NOT NULL default '',
  `adder` char(30) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`nrid`)
) TYPE=MyISAM;

#
# Table structure for table 'watch'
#

# DROP TABLE IF EXISTS watch;
CREATE TABLE `watch` (
  `nrid` int(11) unsigned NOT NULL default '0',
  `mask` char(106) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`nrid`,`mask`),
  KEY `nick` (`nrid`)
) TYPE=MyISAM;

#
# Table structure for table 'welcome'
#
CREATE TABLE `welcome` (
  `chan` varchar(32) NOT NULL default '',
  `id` tinyint(3) NOT NULL default '0',
  `adder` varchar(30) NOT NULL default '',
  `time` int(10) NOT NULL default '0',
  `msg` text NOT NULL,
  PRIMARY KEY  (`chan`,`id`)
) TYPE=MyISAM;

CREATE TABLE `nicktext` (
  `nrid` int(11) unsigned NOT NULL default 0,
  `type` tinyint(3) unsigned NOT NULL default 0,
  `id` mediumint(8) unsigned NOT NULL default 0,
  `chan` varchar(32) default NULL,
  `data` text default NULL,
  PRIMARY KEY (`nrid`, `type`, `id`, `chan`)
) TYPE=MyISAM;


#
# Table structure for table 'tkl'
#

DROP TABLE IF EXISTS `tklban`;
CREATE TABLE `tklban` (
  `type` char(1) NOT NULL default '',
  `ident` char(10) NOT NULL default '',
  `host` char(64) NOT NULL default '',
  `setter` char(106) NOT NULL default '',
  `expire` int(11) unsigned NOT NULL default 0,
  `time` int(11) unsigned NOT NULL default 0,
  `reason` char(255) NOT NULL default '',
  PRIMARY KEY (`type`, `ident`, `host`)
) TYPE = HEAP;

#
# Table structure for table 'spamfilter'
#

DROP TABLE IF EXISTS `spamfilter`;
CREATE TABLE `spamfilter` (
  `target` char(20) NOT NULL default '',
  `action` char(20) NOT NULL default '',
  `setter` char(106) NOT NULL default '',
  `expire` int(11) unsigned NOT NULL default 0,
  `time` int(11) unsigned NOT NULL default 0,
  `bantime` int(11) unsigned NOT NULL default 0,
  `reason` char(255) NOT NULL default '',
  `mask` char(255) NOT NULL default '',
  PRIMARY KEY (`target`, `action`, `mask`)
) TYPE = HEAP;

DROP TABLE IF EXISTS `chanlog`;
CREATE TABLE `chanlog` (
    `chan` char(30) NOT NULL default '',
    `adder` char(30) NOT NULL default '',
    `time` unsigned int NOT NULL default 0,
    `email` varchar(100) NOT NULL default ''
    PRIMARY KEY (`chan`)
) TYPE = MyISAM;

#
# Table structure for table 'chantext'
#

DROP TABLE IF EXISTS `chantext`;
CREATE TABLE `chantext` (
  `chan` varchar(32) NOT NULL default '',
  `type` tinyint(3) unsigned NOT NULL default 0,
  `key` varchar(32) default NULL,
  `data` text default NULL,
  PRIMARY KEY (`chan`, `type`, `key`)
) TYPE=MyISAM;
