# LEVELS work

ALTER TABLE chanperm ADD COLUMN max tinyint(3) unsigned NOT NULL default 0;

UPDATE chanperm SET max = 7 WHERE name IN ('LEVELS', 'LevelsList');
UPDATE chanperm SET max = 1 WHERE name IN ('JOIN');
UPDATE chanperm SET level = 8 WHERE name IN ('GREET');

# Remove all F_GREET flags
UPDATE chanreg SET flags = flags & (~512) WHERE (flags & 512);

# AKick work

CREATE TABLE `akicktmp` (
  `chan` varchar(32) NOT NULL default '',
  `nick` varchar(30) NOT NULL default '',
  `ident` varchar(10) NOT NULL default '',
  `host` varchar(64) NOT NULL default '',
  `adder` varchar(30) NOT NULL default '',
  `reason` text,
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`,`nick`,`ident`,`host`),
  KEY `chan` (`chan`)
);

# We ignore in case of duplicates (akick.nick=nickalias.alias may result in identical nickalias.nrid)
INSERT IGNORE INTO akicktmp SELECT akick.chan, nickalias.nrid, '', '', akick.adder, akick.reason, akick.time
	FROM akick, nickalias
	WHERE nickalias.alias=akick.nick AND akick.ident='' AND akick.host='' ORDER BY chan;
DELETE FROM akick WHERE akick.ident='' AND akick.host='';
INSERT INTO akick SELECT * FROM akicktmp;
DROP TABLE akicktmp;
ANALYZE TABLE akick; OPTIMIZE TABLE akick;
