#!/usr/bin/perl

#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#  SurrealChat.net does not provide the Blacklist Data
#  is in no way associated with blitzed.org,
#  nor are we providing a license to download/use it.
#  Be sure to direct availability/accuracy/licensing questions to 
#  http://opm.blitzed.org/info

use strict;
use DBI;
use Cwd 'abs_path';
use File::Basename;
use Date::Parse;

# as libs::config is in dir ../libs/config.pm
use lib "..";

use libs::config;

my $prefix = dirname(dirname(abs_path($0)).'../');

#my $opmdata_url= 'rsync://rsync.blitzed.org/opm/rbldnsd/opm.blitzed.org.rbldnsd';
my %OPMconf = config::readHash($prefix.'/config/securitybot/sb.opm');
my $opmdata_url= ((defined(%OPMconf) and $OPMconf{opmdata}) ? $OPMconf{opmdata} : 
	'rsync://rsync.blitzed.org/opm/rbldnsd/opm.blitzed.org.rbldnsd');

# As long as this is part of SecurityBot anyhow.
my $MySQL_confFile = "$prefix/config/securitybot/sb.mysql";

my $srcname = 'opm.blitzed.org.rbldnsd';
# Permission is granted to specific IPs to dl.
# Not the most secure, but don't blame me.
my $bindip = undef;
my $unpackname = $srcname;
my $diffname = $srcname.'.diff';

{	print "Synching country-data file...\n";

	system('rsync', '-az', '--progress', $opmdata_url, "$prefix/data/$srcname", '--address='.($bindip ? $bindip : '0.0.0.0'));
	print "$prefix/data/$srcname\n";
	unless(-e "$prefix/data/$srcname") {
		print "FATAL: Download failed.\n";
		exit;
	}
}

#system("diff -uN $prefix/data/$srcname.old $prefix/data/$srcname > $prefix/data/$diffname");

unless(open OPMDATA, '-|', "diff -uN $prefix/data/$srcname.old $prefix/data/$srcname") {
        print "FATAL: Processing failed.\n";
        exit;
}

my %MySQLconf = config::readHash($MySQL_confFile);

print "Connecting to database...\n";

my $dbh;
eval { 
	$dbh = DBI->connect("DBI:mysql:".$MySQLconf{'mysql-db'}, $MySQLconf{'mysql-user'}, $MySQLconf{'mysql-pass'}, 
		{  AutoCommit => 1, RaiseError => 1, PrintError => 1 })
};

if($@) {
	print "FATAL: Can't connect to database:\n$@\n";
	print "You must edit $MySQL_confFile and create a corresponding\nMySQL user and database!\n\n";
	exit;
}

print "Creating new table...\n";

my $add_entry = $dbh->prepare("INSERT IGNORE INTO newopm SET ipaddr=?, ipnum=?, type=?");
my $del_entry = $dbh->prepare("DELETE QUICK FROM newopm WHERE ipnum=?");

$dbh->do("DROP TABLE IF EXISTS `newopm`");
$dbh->do(
"CREATE TABLE `newopm` (
	`ipnum` int(11) unsigned NOT NULL default 0,
	`ipaddr` char(15) NOT NULL default '0.0.0.0',
	`type` tinyint(3) NOT NULL default 0,
	PRIMARY KEY (`ipnum`),
	UNIQUE KEY `addrkey` (`ipaddr`)
) TYPE=MyISAM;"
);

my $copy_table = $dbh->prepare("INSERT INTO `newopm` SELECT * FROM `opm`");
$copy_table->execute; $copy_table->finish();

print "Inserting data...     ";

my (@add, @del);
while(my $x = <OPMDATA>) {
	chomp $x;
	#85.10.224.152/29 :127.0.0.20:ad
	$x =~ /\/(\d{1,2}) \:(\S+)\:([a-z]{2})/;
	if ($x =~ /^([ -+])(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3}) \:127\.1\.(\d{1,3})\.(\d{1,3}):/) {
		my $IP = $2 << 24 | $3 << 16 | $4 << 8 | $5;
		my $type = $6 << 8 | $7;
		#print "$x\n$1 $2 $3 $4 $5 $7\n";
		#print "$x\n";
		#print "$low $high $country\n";
		#$add_entry->execute("$1.$2.$3.$4", $IP, $type) if $1 eq '+';
		#$del_entry->execute($IP) if $1 eq '+';
		push @add, ["$2.$3.$4.$5", $IP, $type] if $1 eq '+';
		push @del, $IP if $2 eq '-';
	}
}
close OPMDATA;
#rename($unpackname, $srcname.'.old');
system('cp', '-f', "$prefix/data/$unpackname", "$prefix/data/$srcname.old");


$dbh->do("ALTER TABLE `newopm` DISABLE KEYS");
$dbh->do("LOCK TABLES newopm WRITE");
foreach my $ipnum (@del) {
	$del_entry->execute($ipnum);
}
my $query = "REPLACE INTO `newopm` (ipnum, ipaddr, type) VALUES ";
my $counter = 0;
foreach my $add_entry (@add) {
	my ($ipaddr, $ipnum, $type) = @$add_entry;
	$query .= '('.$ipnum.','.$dbh->quote($ipaddr).','.$type.'),';
	if (++$counter >= 100) {
		$query =~ s/\,$//;
		my $add_query = $dbh->prepare($query);
		$add_query->execute();
		$query = "REPLACE INTO `newopm` (ipnum, ipaddr, type) VALUES ";
		$counter = 0;
	}
}
if ($counter) {
	$query =~ s/\,$//;
	my $add_query = $dbh->prepare($query);
	$add_query->execute();
}

$dbh->do("UNLOCK TABLES");
$dbh->do("ALTER TABLE `newopm` ENABLE KEYS");


print "\b\b\b\bdone.\nRemoving old table...\n";
$dbh->do("DROP TABLE IF EXISTS `oldopm`");
$dbh->do("OPTIMIZE TABLE `newopm`");
print "Renaming new table...\n";
$dbh->do("RENAME TABLE `opm` TO `oldopm`, `newopm` TO `opm`");
$dbh->do("DROP TABLE IF EXISTS `oldopm`");

print "Country table update complete.\n";

exit;
