#!/usr/bin/perl

#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
use strict;
use DBI;

use Getopt::Long;

use modules::serviceslibs::svsdb;
use Cwd 'abs_path';
use File::Basename;
 
our $delete_db;
GetOptions (
	"delete" => \$delete_db,
);

my $prefix = dirname(abs_path($0));

use SrSv::Conf 'sql';

print "Connecting...\n";

my $dbh;
eval { $dbh = DBI->connect("DBI:mysql:".$sql_conf{'mysql-db'}, $sql_conf{'mysql-user'}, $sql_conf{'mysql-pass'}, {  AutoCommit => 1, RaiseError => 1 }) };

if($@) {
	print "FATAL: Can't connect to database:\n$@\n";
	print "You must edit config/services.conf and create a corresponding\nMySQL user and database!\n\n";
	exit;
}

if($delete_db) {
	print "Really delete all data in database: $sql_conf{'mysql-db'}? (y/N) ";
	exit unless lc getc eq 'y';

	print "Deleting old tables...\n";

	my $table_list = $dbh->prepare("SHOW TABLES");
	$table_list->execute;
	while(my $t = $table_list->fetchrow_array) {
		$dbh->do("DROP TABLE $t");
	}
}

print "Creating tables...\n";

$dbh->{RaiseError} = 0;
$dbh->{PrintError} = 0;

open SQL, "sql/services.sql";
my $sql;
while(my $x = <SQL>) { $sql .= $x unless $x =~ /^#/ or $x eq '\n'}
foreach my $line (split(/;/s, $sql)) {
	$dbh->do($line);
}

print "Updating chanperm...\n";

my $add_perm = $dbh->prepare("INSERT IGNORE INTO chanperm SET name=?, level=?, max=?");
my $del_perm = $dbh->prepare("DELETE FROM chanperm WHERE name=?");

my @perms = (
	['Join', 0, 1],
	['AccList', 1, 0],
	['AccChange', 5, 0],
	['AKICK', 5, 0],
	['AKickList', 3, 0],
	['AKickEnforce', 5, 0],
	['SET', 6, 0],
	['BAN', 4, 0],
	['CLEAR', 6, 0],
	['GETKEY', 4, 0],
	['INFO', 0, 0],
	['KICK', 4, 0],
	['LEVELS', 6, 7],
	['LevelsList', 3, 7],
	['INVITE', 4, 0],
	['InviteSelf', 1, 0],
	['TOPIC', 5, 0],
	['UnbanSelf', 4, 0],
	['UNBAN', 5, 0],
	['VOICE', 2, 0],
	['HALFOP', 3, 0],
	['OP', 4, 0],
	['ADMIN', 5, 0],
	['OWNER', 6, 0],
	['Memo', 5, 0],
	['BadWords', 5, 0],
	['Greet', 1, 0],
	['NoKick', 4, 0],
	['BotSay', 5, 0],
	['BotAssign', 6, 0],
	['SetTopic', 0, 0],
	['WELCOME', 6, 0],
	['DICE', 1, 0],
	['UPDOWN', 1, 0],
);

my @noperms = ();

foreach my $p (@perms) {
	$add_perm->execute($p->[0], $p->[1], $p->[2]);
}

foreach my $p (@noperms) {
	$del_perm->execute($p);
}

print "Updating nick IDs...\n";

$svsdb::dbh = $dbh;
svsdb::nrid_convert();

print "Database setup complete!\n";
