package config;

#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use SrSv::SimpleHash qw(readHash writeHash);

our %conf;

sub loadconfig {
	%conf = readHash("$main::prefix/config/main.conf");
}

sub writeArray {
        my $array = $_[0];
        my $file = $_[1];

        open ARRAY, ">$file";

        foreach my $x (@$array) {
                print ARRAY $x . "\n";
        }

        close ARRAY;
}

sub readArray {
        my $file = $_[0];
        my @array;

        open ARRAY, $file;

        while(my $x = <ARRAY>) {
                chomp $x;
                push @array, $x;
        }

        close ARRAY;

        return (@array);
}

1;
