#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
package fmt;
use strict;

# Formats a list like "foo, bar, and baz"
sub enum($@) {
	my ($conj, @list) = @_;

	my $el;
	$el = " $conj ".pop(@list) if(@list > 1);
	if(@list > 1) {
		$el = join(", ", @list) . ",$el";
	} else {
		$el = @list[0].$el;
	}

	return $el;
}

# Portions of wordwrap() taken from 
# Bjoern 'fuchs' Krombholz splitlong.pl
# bjkro@gmx.de
sub wordwrap ($$) {
	my ($data, $maxlength) = @_;

	return ($data)
		if (length($data) <= $maxlength);

	my $lstart = '...';
	my $lend = '...';
	my $maxlength2 = $maxlength - length($lend);

	my @spltarr;
	while (length($data) > ($maxlength2)) {
		my $pos = rindex($data, " ", $maxlength2);
		push @spltarr, substr($data, 0, ($pos < ($maxlength/10 + 4)) ? $maxlength2  : $pos)  . $lend;
		$data = $lstart . substr($data, ($pos < ($maxlength/10 + 4)) ? $maxlength2 : $pos + 1);
	}
	push @spltarr, $data;

	return @spltarr;
}

1;
