#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
package core;

use SrSv::Conf 'main';
use SrSv::RunLevel 'main_shutdown';
use SrSv::IRCd::Event 'addhandler';
use SrSv::IRCd::IO 'ircsend';
use SrSv::Timer 'add_timer';
use SrSv::Agent;
use SrSv::Process::Init; #FIXME - only needed for ccode
#FIXME
#use SrSv::User::Notice;
sub notice {
	net::notice('ServServ', shift()->{NICK}, shift);
}

our %ccode; #FIXME - Split out
proc_init {
	open COUNTRY, "$main::prefix/data/country-codes.txt";
	while(my $x = <COUNTRY>) {
		chomp $x;
		my($code, $country) = split(/   /, $x);
		$ccode{uc $code} = $country;
	}
	close COUNTRY;
};

our $rsnick = 'ServServ';

addhandler('PING', undef, undef, 'net::pong', 1);

sub pingtimer($) {
	net::ping();
	add_timer('perlserv__pingtimer', 60, __PACKAGE__, 
			"core::pingtimer");
}

agent_connect($rsnick, 'service', undef, '+ABHSNaopqz', 'Services Control Agent');

addhandler('SEOS', undef, undef, 'core::ev_connect', 1);

sub ev_connect {
	agent_join($rsnick, $main_conf{diag});
	net::setmode($rsnick, $main_conf{diag}, '+o', $rsnick);
	add_timer('perlserv__pingtimer', 60, __PACKAGE__,
			"core::pingtimer");
}

addhandler('PRIVMSG', undef, 'servserv', 'core::dispatch', 1);

sub dispatch {
	my ($src, $dst, $msg) = @_;
	my $user = { NICK => $src, AGENT => $rsnick };
	if(!adminserv::is_ircop($user)) {
		notice($user, 'Access Denied');
		net::globops($rsnick, "\002$src\002 failed access to $rsnick $msg");
		return;
	}
	if($msg =~ /^lsmod/i) {
		notice($user, $main_conf{load});
	}

	if($msg =~ /^shutdown/i) {
		if(!adminserv::is_svsop($user, adminserv::S_ADMIN() )) {
			notice($user, 'You do not have sufficient rank for this command');
			return;
		}
		
		main_shutdown;
	}
	if($msg =~ /^raw/i) {
		if(!adminserv::is_svsop($user, adminserv::S_ROOT() )) {
			notice($user, 'You do not have sufficient rank for this command');
			return;
		}
		my $cmd = $msg;
		$cmd =~ s/raw\s+//i;
		ircsend($cmd);
	}
	if($msg =~ /^help$/) {
		help::sendhelp($rsnick, $src, lc 'core');
		return;
	}
	if(main::DEBUG and $msg =~ /^eval\s+(.*)/) {
		my $out = eval($1);
		notice($user, split(/\n/, $out.$@));
	}
}

sub init { }
sub begin { }
sub end { }
sub unload { }

1;
