# CREATE DATABASE services;
# USE services;

DROP TABLE IF EXISTS chan;
CREATE TABLE `chan` (
  `chan` char(32) NOT NULL default '',
  `modes` char(63) binary NOT NULL default '',
  `seq` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`)
) TYPE=HEAP;

#
# Table structure for table 'chanban'
#

DROP TABLE IF EXISTS chanban;
CREATE TABLE `chanban` (
  `chan` varchar(32) NOT NULL default '',
  `mask` varchar(110) NOT NULL default '',
  `setter` varchar(30) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `type` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chan`,`mask`,`type`)
) TYPE=HEAP;

#
# Table structure for table 'chanuser'
#

DROP TABLE IF EXISTS chanuser;
CREATE TABLE `chanuser` (
  `seq` mediumint(8) unsigned NOT NULL default '0',
  `nickid` int(11) unsigned NOT NULL default '0',
  `chan` char(32) NOT NULL default '',
  `joined` tinyint(3) unsigned NOT NULL default '0',
  `op` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`nickid`,`chan`),
  KEY `chan` (`chan`),
  KEY `nickid` (`nickid`)
) TYPE=HEAP;

#
# Table structure for table 'nickchg'
#

DROP TABLE IF EXISTS nickchg;
CREATE TABLE `nickchg` (
  `seq` mediumint(8) unsigned NOT NULL default '0',
  `nickid` int(11) unsigned NOT NULL default '0',
  `nick` char(30) NOT NULL default '',
  PRIMARY KEY  (`nick`)
) TYPE=HEAP;

#
# Table structure for table 'nickid'
#

DROP TABLE IF EXISTS nickid;
CREATE TABLE `nickid` (
  `id` int(10) unsigned NOT NULL default '0',
  `nrid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`,`nrid`),
  KEY `id` (`id`)
) TYPE=HEAP;

#
# Table structure for table 'user'
#

DROP TABLE IF EXISTS user;
CREATE TABLE `user` (
  `id` int(11) unsigned NOT NULL default '0',
  `nick` char(30) NOT NULL default '',
  `time` int(11) unsigned NOT NULL default '0',
  `inval` tinyint(4) NOT NULL default '0',
  `ident` char(10) NOT NULL default '',
  `host` char(64) NOT NULL default '',
  `vhost` char(64) NOT NULL default '',
  `ip` int(8) unsigned NOT NULL default '0',
  `server` char(64) NOT NULL default '',
  `modes` char(30) NOT NULL default '',
  `gecos` char(50) NOT NULL default '',
  `guest` tinyint(1) NOT NULL default '0',
  `online` tinyint(1) unsigned NOT NULL default '0',
  `quittime` int(11) unsigned NOT NULL default '0',
  `flood` tinyint(1) unsigned NOT NULL default '0',
  `flags` mediumint(10) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nick` (`nick`),
  KEY `ip` (`ip`)
) TYPE=HEAP;

#
# Table structure for table 'tkl'
#

DROP TABLE IF EXISTS `tklban`;
CREATE TABLE `tklban` (
  `type` char(1) NOT NULL default '',
  `ident` char(10) NOT NULL default '',
  `host` char(64) NOT NULL default '',
  `setter` char(106) NOT NULL default '',
  `expire` int(11) unsigned NOT NULL default 0,
  `time` int(11) unsigned NOT NULL default 0,
  `reason` char(255) NOT NULL default '',
  PRIMARY KEY (`type`, `ident`, `host`)
) TYPE = HEAP;

#
# Table structure for table 'spamfilter'
#

DROP TABLE IF EXISTS `spamfilter`;
CREATE TABLE `spamfilter` (
  `target` char(20) NOT NULL default '',
  `action` char(20) NOT NULL default '',
  `setter` char(106) NOT NULL default '',
  `expire` int(11) unsigned NOT NULL default 0,
  `time` int(11) unsigned NOT NULL default 0,
  `bantime` int(11) unsigned NOT NULL default 0,
  `reason` char(255) NOT NULL default '',
  `mask` char(255) NOT NULL default '',
  PRIMARY KEY (`target`, `action`, `mask`)
) TYPE = HEAP;
