#!/usr/bin/perl

#	This file is part of SurrealServices.
#
#	SurrealServices is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	SurrealServices is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with SurrealServices; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#  SurrealChat.net does not provide the Country/Allocation data,
#  is in no way associated with maxmind.com,
#  nor are we providing a license to download/use it.
#  Be sure to direct availability/accuracy/licensing questions to maxmind.com

use strict;
use DBI;
use Cwd 'abs_path';
use File::Basename;
use Date::Parse;

use libs::config;

my $prefix = dirname(dirname(abs_path($0)).'../');

my $countrydb_url= 'rsync://nubian.blitzed.org/countries/zz.countries.nerd.dk.rbldnsd';
my $srcname = 'zz.countries.nerd.dk.rbldnsd';
my $unpackname = $srcname;

{	print "Synching country-data file...\n";

	system("rsync -azvv --progress $countrydb_url $prefix/data/$srcname");
	unless(-e "$prefix/data/$srcname") {
		print "FATAL: Download failed.\n";
		exit;
	}
}

unless(open COUNTRYTABLE, "$prefix/data/$unpackname") {
        print "FATAL: Decompression failed.\n";
        exit;
}

my %conf = config::readHash("$prefix/config/services.conf");

print "Connecting to database...\n";

my $dbh;
eval { 
	$dbh = DBI->connect("DBI:mysql:".$conf{'mysql-db'}, $conf{'mysql-user'}, $conf{'mysql-pass'}, 
		{  AutoCommit => 1, RaiseError => 1, PrintError => 1 })
};

if($@) {
	print "FATAL: Can't connect to database:\n$@\n";
	print "You must edit config/services.conf and create a corresponding\nMySQL user and database!\n\n";
	exit;
}

print "Creating new table...\n";

my $add_entry = $dbh->prepare("INSERT IGNORE INTO newcountry SET low=?, high=?, country=?");

$dbh->do("DROP TABLE IF EXISTS newcountry");
$dbh->do(
"CREATE TABLE `newcountry` (
  `low` int unsigned NOT NULL default 0,
  `high` int unsigned NOT NULL default 0,
  `country` char(2) NOT NULL default '-',
  PRIMARY KEY (`low`, `high`)
) TYPE=MyISAM"
);

print "Inserting data...     ";

$| = 1;
my ($lines) = qx{wc -l $prefix/data/$unpackname};
my $div = int($lines/100);
my $i;

$dbh->do("ALTER TABLE `newcountry` DISABLE KEYS");
$dbh->do("LOCK TABLES newcountry WRITE");
while(my $x = <COUNTRYTABLE>) {
	if($i == 0 or !($i % $div)) {
		printf("\b\b\b\b%3d%", ($i/$lines)*100);
	}
	
	chomp $x;
	#85.10.224.152/29 :127.0.0.20:ad
#	$x =~ /\/(\d{1,2}) \:(\S+)\:([a-z]{2})/;
	if ($x =~ /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})\/(\d{1,2}) \:(\S+)\:([a-z]{1,2})$/) {
		my $low = $1 << 24 | $2 << 16 | $3 << 8 | $4;
		my $high = $low + ((2 << (31-$5)));
		my $country = $7;
		#print "$x\n$1 $2 $3 $4 $5 $7\n";
		#print "$x\n";
		#print "$low $high $country\n";
		$add_entry->execute($low, $high, $country);
	}

	$i++;
}
$dbh->do("UNLOCK TABLES");
$dbh->do("ALTER TABLE `newcountry` ENABLE KEYS");
close COUNTRYTABLE;

print "\b\b\b\bdone.\nRemoving old table...\n";
$dbh->do("DROP TABLE IF EXISTS `oldcountry`");
print "Renaming new table...\n";
$dbh->{RaiseError} = 0;
$dbh->do("RENAME TABLE `country` TO `oldcountry`");
$dbh->do("RENAME TABLE `newcountry` TO `country`");
$dbh->do("DROP TABLE `oldcountry`");

print "Country table update complete.\n";

exit;
