#!/usr/bin/perl

#       This file is part of SurrealServices.
#
#       SurrealServices is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       SurrealServices is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with SurrealServices; if not, write to the Free Software
#       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use Cwd 'abs_path';
use File::Basename;
#use DBI;
# as libs::config is in dir ../libs/config.pm
use lib "..";

use libs::config;
use libs::misc;
use SrSv::Time;
use lib "../libs";
use MIME::Lite;

my $prefix = dirname(dirname(abs_path($0)).'../');
my $logdir = "$prefix/logs/";

#my $MySQL_confFile = "$prefix/config/logserv.conf";

my %main_conf = config::readHash("$prefix/config/main.conf");

opendir LOGDIR, $logdir;

my $i = 0; my @today = gmt_date();
while (my $filename = readdir(LOGDIR)) {
	next unless $filename !~ /^\.\.?$/ and $filename !~ /\.(gz|bz2)$/ and -f "$logdir/$filename";
	if($filename =~ /^services.log-(\d{4})-(\d{2})-(\d{2})$/i) {
		my ($year, $month, $day) = ($1, $2, $3);
		# Don't process today's logs
		if($year == $today[0] and $month == $today[1] and $day == $today[3]) {
			print "Skipping $filename\n";
			next;
		}

		my $msg = MIME::Lite->new(
			From 	=> $main_conf{email},
			To 	=> $main_conf{logmail},
			Subject => $filename,
			Type	=> 'multipart/mixed'
		);
		$msg->attach (
			Type	=> 'TEXT',
			Data	=> 'File is attached.'
		);
		$msg->attach (
			Type 	=> 'x-gzip',
			Path    => "gzip -9 < $logdir/$filename |",
			ReadNow	=> 1,
			Filename => $filename.'.gz'
		);
		$msg->send;
		print "We sent the message $filename\n";
		if ( !(-d "$logdir/$year/$month")) {
			mkdir "$logdir/$year" unless (-d $year);
			mkdir "$logdir/$year/$month";
		}
		# rename is 'move'
		rename "$logdir/$filename", "$logdir/$year/$month/$filename";
		$i++;
	}
	elsif ($filename =~ /^#.*\.log-(\d{4})-(\d{2})-(\d{2})$/i) {
		# We don't process channel logs yet.
	}
}
closedir LOGDIR;

print "Processed $i logs\n";
